/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.peer.LabelPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class Label
extends Component
implements Accessible {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    String text;
    int alignment = 0;
    private static final String base = "label";
    private static int nameCounter;
    private static final long serialVersionUID = 3094126758329070636L;

    public int getAlignment() {
        return this.alignment;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Label.initIDs();
        }
        nameCounter = 0;
    }

    public Label() throws HeadlessException {
        this("", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createLabel(this);
            }
            super.addNotify();
        }
    }

    private static native void initIDs();

    public synchronized void setAlignment(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.alignment = n2;
                LabelPeer labelPeer = (LabelPeer)this.peer;
                if (labelPeer != null) {
                    labelPeer.setAlignment(n2);
                }
                return;
            }
        }
        throw new IllegalArgumentException("improper alignment: " + n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public String getText() {
        return this.text;
    }

    protected String paramString() {
        String string = ",align=";
        switch (this.alignment) {
            case 0: {
                string = string + "left";
                break;
            }
            case 1: {
                string = string + "center";
                break;
            }
            case 2: {
                string = string + "right";
            }
        }
        return super.paramString() + string + ",text=" + this.text;
    }

    public Label(String string) throws HeadlessException {
        this(string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        boolean bl2 = false;
        Label label = this;
        synchronized (label) {
            if (!(string == this.text || this.text != null && this.text.equals(string))) {
                this.text = string;
                LabelPeer labelPeer = (LabelPeer)this.peer;
                if (labelPeer != null) {
                    labelPeer.setText(string);
                }
                bl2 = true;
            }
        }
        if (bl2 && this.valid) {
            this.invalidate();
        }
    }

    public Label(String string, int n2) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.text = string;
        this.setAlignment(n2);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTLabel(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTLabel
    extends Component.AccessibleAWTComponent {
        private final Label this$0;

        public AccessibleAWTLabel(Label label) {
            this.this$0 = label;
            super(label);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.this$0.getText() == null) {
                return super.getAccessibleName();
            }
            return this.this$0.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }
    }
}

